/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.logon;

import com.ibm.hwmca.fw.connmgr.ConnectionConstants;
import com.ibm.hwmca.fw.connmgr.DisabledUseridException;
import com.ibm.hwmca.fw.connmgr.InvalidPasswordException;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.logon.LogonManager;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.util.Bag;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LogonValidation
implements ConnectionConstants {
    public static final LogonValidation GATE_KEEPER = new LogonValidation();
    public static final int SLEEP_TIME = 5000;
    public static final int MAX_SLEEP_TIME = 15000;
    public static final long ONE_HOUR = 3600000L;
    private Bag _failedLogons = new Bag();
    private Map _failedLogonDate = new HashMap();
    private static final String TRACE_MASKT = "XFRMUSRT";
    private static final String TRACE_MASKF = "XFRMUSRF";
    private static final String TRACE_MASKD = "XFRMUSRD";

    private LogonValidation() {
    }

    public byte[] lookupPassword(String userName) throws InvalidPasswordException, DisabledUseridException {
        Trace.trace(TRACE_MASKF, "lookupPassword " + userName);
        User myUser = User.getUser(userName);
        if (myUser == null) {
            this.recordFailedLogonAttempt(userName);
            throw new InvalidPasswordException(userName);
        }
        if (myUser.isDisabled()) {
            this.recordFailedLogonAttempt(userName);
            throw new DisabledUseridException(myUser);
        }
        return myUser.getPassword();
    }

    public void recordFailedLogonAttempt(String userName) {
        int sleepSec = 0;
        Trace.trace(TRACE_MASKF, "recordFailedLogonAttempt:  " + userName);
        User myUser = User.getUser(userName);
        if (myUser != null) {
            this.logLogonWarning(userName);
            Date lastFailureDate = (Date)this._failedLogonDate.get(userName);
            Date now = new Date();
            this._failedLogonDate.put(userName, now);
            if (lastFailureDate != null && LogonValidation.elapsedTime(lastFailureDate, now) > 3600000L) {
                this._failedLogons.removeAll(userName);
            }
            this._failedLogons.add(userName);
        }
        try {
            sleepSec = this._failedLogons.countOf(userName) * 5000;
            Thread.sleep(Math.min(15000, sleepSec));
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (this._failedLogons.countOf(userName) >= 3) {
            this.logLogonFailure(this._failedLogons.countOf(userName), userName);
        }
    }

    private static long elapsedTime(Date first, Date next) {
        return next.getTime() - first.getTime();
    }

    public void recordSuccessfulLogonAttempt(String userName) {
        Trace.trace(TRACE_MASKF, "recordSuccessfulLogonAttempt:  " + userName);
        this._failedLogons.removeAll(userName);
        this._failedLogonDate.remove(userName);
        this.logLogonSuccess(userName);
        LogonManager.getLogonManager();
        LogonManager.logOn();
    }

    private void logLogonFailure(int attempts, String userName) {
        String[] subst = new String[]{String.valueOf(attempts), userName};
        FrameworkEventText fet = new FrameworkEventText(859, subst);
        SystemEventLog logEvent = new SystemEventLog(fet, "LOGON_SECURITY");
        logEvent.log();
        E4EventLog e4EventLog = new E4EventLog(fet, "LOGON_SECURITY");
        e4EventLog.log();
    }

    private void logLogonSuccess(String userName) {
        String[] subst = new String[]{userName, userName};
        FrameworkEventText fet = new FrameworkEventText(216, subst);
        SystemEventLog logEvent = new SystemEventLog(fet, "EUSRMODE");
        logEvent.log();
        E4EventLog e4EventLog = new E4EventLog(fet, "EUSRMODE");
        e4EventLog.log();
        if (userName.equals("pedebug") || userName.equals("PEDEBUG")) {
            fet = new FrameworkEventText(38, subst);
            logEvent = new SystemEventLog(fet, "PCLGNDBG");
            logEvent.log();
            e4EventLog = new E4EventLog(fet, "PCLGNDBG");
            e4EventLog.log();
        }
    }

    private void logLogonWarning(String userName) {
        String[] subst = new String[]{userName};
        FrameworkEventText fet = new FrameworkEventText(522, subst);
        SystemEventLog logEvent = new SystemEventLog(fet, "CPC_BADLOGON");
        logEvent.log();
        E4EventLog e4EventLog = new E4EventLog(fet, "CPC_BADLOGON");
        e4EventLog.log();
    }

    public boolean isPasswordExpired(User user) {
        long expires;
        long now = new Date().getTime();
        return now > (expires = user.getExpirationStartDate() + (long)(user.getPasswordExpiration() * 24 * 60 * 60 * 1000));
    }
}

